#ifndef __X4D_SCALE_LINE__
#define __X4D_SCALE_LINE__

#include	"x4d_filter.h"

//----------------------------------------------------------------------------------------
// functions for growing a line
//----------------------------------------------------------------------------------------
extern void	grow_line_px1_8( LONG e, LONG sw, LONG dw, LONG cnt,
														 LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
														 ULONG *src, ULONG *dst );

extern void	grow_line_px16( LONG e, LONG sw, LONG dw, LONG cnt,
														LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
														UWORD *src, UWORD *dst );

extern void	grow_line_px24( LONG e, LONG sw, LONG dw, LONG cnt,
														LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
							 							UCHAR *src, UCHAR *dst );

extern void	grow_line_px32( LONG e, LONG sw, LONG dw, LONG cnt,
														LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
														ULONG *src, ULONG *dst );

//----------------------------------------------------------------------------------------
// additional name definitions
//----------------------------------------------------------------------------------------
#define	grow_line_xRGB15	grow_line_px16
#define	grow_line_RGB24		grow_line_px24
#define	grow_line_xRGB24	grow_line_px32

#define	grow_line_G8			grow_line_px1_8
#define	grow_line_G16			grow_line_px16
#define	grow_line_AG16		grow_line_px16
#define	grow_line_AG32		grow_line_px32

#define	grow_line_Lab24		grow_line_px24
#define	grow_line_xLab24	grow_line_px32


//----------------------------------------------------------------------------------------
// functions for shrinking a line
//----------------------------------------------------------------------------------------
extern void	shrink_line_px1_8( LONG e, LONG sw, LONG dw, LONG cnt,
															 LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
															 ULONG *src, ULONG *dst );

extern void	shrink_line_A8( LONG e, LONG sw, LONG dw, LONG cnt,
														LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
														UCHAR *src, UCHAR *dst );

extern void	shrink_line_xABC15( LONG e, LONG sw, LONG dw, LONG cnt,
																LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
																UWORD *src, UWORD *dst );

extern void	shrink_line_AB16( LONG e, LONG sw, LONG dw, LONG cnt,
															LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
															UWORD *src, UWORD *dst );

extern void	shrink_line_A16( LONG e, LONG sw, LONG dw, LONG cnt,
														 LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
														 UWORD *src, UWORD *dst );

extern void	shrink_line_AG16( LONG e, LONG sw, LONG dw, LONG cnt,
															LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
															UWORD *src, UWORD *dst );

extern void	shrink_line_ABC24( LONG e, LONG sw, LONG dw, LONG cnt,
															 LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
															 UCHAR *src, UCHAR *dst );

extern void	shrink_line_xABC24( LONG e, LONG sw, LONG dw, LONG cnt,
																LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
																ULONG *src, ULONG *dst );

extern void	shrink_line_ABCD32( LONG e, LONG sw, LONG dw, LONG cnt,
																LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
																ULONG *src, ULONG *dst );

extern void	shrink_line_ARGB32( LONG e, LONG sw, LONG dw, LONG cnt,
															  LONG bits, LONG src_bit_offset, LONG dst_bit_offset,
															  ULONG *src, ULONG *dst );

//----------------------------------------------------------------------------------------
// additional name definitions
//----------------------------------------------------------------------------------------
#define	shrink_line_xRGB15	shrink_line_xABC15
#define	shrink_line_RGB24		shrink_line_ABC24
#define	shrink_line_xRGB24	shrink_line_xABC24

#define	shrink_line_G8			shrink_line_A8
#define	shrink_line_G16			shrink_line_A16

#define	shrink_line_Lab24		shrink_line_ABC24
#define	shrink_line_xLab24	shrink_line_xABC24

#endif